-- Format the measures impacts table for the ex ante database, using three significant figures where appropriate 
--   and linking the appropriate impact profiles for this measure group.
SET search_path TO "MC_results_database";
DROP TABLE IF EXISTS meas_impacts_2020_reshvac;
CREATE TABLE meas_impacts_2020_reshvac AS 
SELECT
meas_impacts_wtd."EnergyImpactID"::VARCHAR,
"Version"::VARCHAR,
"VersionSource"::VARCHAR,
"LastMod"::TIMESTAMP,
"PA",
"BldgType",
"BldgVint",
"BldgLoc",
"BldgHVAC",
(CASE WHEN "NormUnit" = 'ResCoolCap' THEN 'Cap-Tons' ELSE 'Cap-kBTUh' END)::VARCHAR as "NormUnit",
(case "NumUnit" when 0 then 0 else round("NumUnit"::Numeric(15,5),(2-floor(log(abs("NumUnit"))))::SMALLINT) end)::float4 as "NumUnit", 
(case "MeasArea" when 0 then 0 else round("MeasArea"::Numeric(15,5),(2-floor(log(abs("MeasArea"))))::SMALLINT) end)::float4 as "MeasArea", 
"ScaleBasis",
--"APreWBkWh_0",
(case "APreWBkWh" when 0 then 0 else round("APreWBkWh"::Numeric(15,5),(2-floor(log(abs("APreWBkWh"))))::SMALLINT) end)::float4 as "APreWBkWh", 
--"APreWBkW_0",
(case "APreWBkW" when 0 then 0 else round("APreWBkW"::Numeric(15,5),(2-floor(log(abs("APreWBkW"))))::SMALLINT) end)::float4 as "APreWBkW", 
--"APreWBtherm_0",
(case "APreWBtherm" when 0 then 0 else round("APreWBtherm"::Numeric(15,5),(2-floor(log(abs("APreWBtherm"))))::SMALLINT) end)::float4 as "APreWBtherm", 
--"AStdWBkWh_0",
(case "AStdWBkWh" when 0 then 0 else round("AStdWBkWh"::Numeric(15,5),(2-floor(log(abs("AStdWBkWh"))))::SMALLINT) end)::float4 as "AStdWBkWh", 
--"AStdWBkW_0",
(case "AStdWBkW" when 0 then 0 else round("AStdWBkW"::Numeric(15,5),(2-floor(log(abs("AStdWBkW"))))::SMALLINT) end)::float4 as "AStdWBkW", 
--"AStdWBtherm_0",
(case "AStdWBtherm" when 0 then 0 else round("AStdWBtherm"::Numeric(15,5),(2-floor(log(abs("AStdWBtherm"))))::SMALLINT) end)::float4 as "AStdWBtherm",
NULL::FLOAT4 as "APreEUkWh",
NULL::FLOAT4 as "APreEUkW",
NULL::FLOAT4 as "APreEUtherm",
NULL::FLOAT4 as "AStdEUkWh",
NULL::FLOAT4 as "AStdEUkW",
NULL::FLOAT4 as "AStdEUtherm",
"ElecImpactProfileID",
"GasImpactProfileID",
20::INT2 as "Flag",
''::VARCHAR as "SourceDesc"
FROM
meas_impacts_wtd
LEFT JOIN "ImpactProfiles" on "ImpactProfiles"."EnergyImpactID" = meas_impacts_wtd."EnergyImpactID";

ALTER TABLE "meas_impacts_2020_reshvac"
ALTER COLUMN "EnergyImpactID" SET NOT NULL,
ALTER COLUMN "PA" SET NOT NULL,
ALTER COLUMN "BldgType" SET NOT NULL,
ALTER COLUMN "BldgVint" SET NOT NULL,
ALTER COLUMN "BldgLoc" SET NOT NULL,
ALTER COLUMN "BldgHVAC" SET NOT NULL,
ADD PRIMARY KEY ("EnergyImpactID", "PA", "BldgType", "BldgVint", "BldgLoc", "BldgHVAC");
